<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Pendaftaran;

/**
 * PendaftaranSearch represents the model behind the search form of `backend\models\Pendaftaran`.
 */
class PendaftaranSearch extends Pendaftaran
{
    public function rules()
    {
        return [
            [['id', 'fakultas_id', 'jenjang_id', 'prodi_id', 'jumlah_revisi'], 'integer'],
            [['email', 'judul_karya_ilmiah', 'nama_lengkap', 'nim', 'pembimbing_1', 'pembimbing_2', 'nomor_handphone', 'jenis_kelamin', 'status', 'status_persetujuan', 'file_path'], 'safe'],
        ];
    }

    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    public function search($params)
    {
        $query = Pendaftaran::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => ['pageSize' => 20],
            'sort' => ['defaultOrder' => ['id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        // Filter pencarian
        $query->andFilterWhere([
            'id' => $this->id,
            'fakultas_id' => $this->fakultas_id,
            'jenjang_id' => $this->jenjang_id,
            'prodi_id' => $this->prodi_id,
            'jumlah_revisi' => $this->jumlah_revisi,
        ]);

        $query->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'judul_karya_ilmiah', $this->judul_karya_ilmiah])
            ->andFilterWhere(['like', 'nama_lengkap', $this->nama_lengkap])
            ->andFilterWhere(['like', 'nim', $this->nim])
            ->andFilterWhere(['like', 'pembimbing_1', $this->pembimbing_1])
            ->andFilterWhere(['like', 'pembimbing_2', $this->pembimbing_2])
            ->andFilterWhere(['like', 'nomor_handphone', $this->nomor_handphone])
            ->andFilterWhere(['like', 'jenis_kelamin', $this->jenis_kelamin])
            ->andFilterWhere(['like', 'status', $this->status])
            ->andFilterWhere(['like', 'status_persetujuan', $this->status_persetujuan])
            ->andFilterWhere(['like', 'file_path', $this->file_path]);

        return $dataProvider;
    }
}
