<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model backend\models\Pendaftaran */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="pendaftaran-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'email')->textInput() ?>
    <?= $form->field($model, 'judul_karya_ilmiah')->textInput() ?>
    <?= $form->field($model, 'nama_lengkap')->textInput() ?>
    <?= $form->field($model, 'nim')->textInput() ?>

    <?= $form->field($model, 'fakultas_id')
    ->dropDownList($fakultasList, ['prompt' => 'Pilih Fakultas', 'id' => 'fakultas-id']) ?>

<?= $form->field($model, 'jenjang_id')
    ->dropDownList([], ['prompt' => 'Pilih Jenjang', 'id' => 'jenjang-id']) ?>

<?= $form->field($model, 'prodi_id')
    ->dropDownList([], ['prompt' => 'Pilih Prodi', 'id' => 'prodi-id']) ?>


    <?= $form->field($model, 'pembimbing_1')->textInput() ?>
    <?= $form->field($model, 'pembimbing_2')->textInput() ?>
    <?= $form->field($model, 'unggah_lembar_persetujuan')->fileInput() ?>
    <?= $form->field($model, 'nomor_handphone')->textInput() ?>
    <?= $form->field($model, 'jenis_kelamin')->dropDownList(['L' => 'Laki-laki', 'P' => 'Perempuan'], ['prompt' => 'Pilih']) ?>

     <!-- Tambahkan kolom-kolom berikut -->
     <?= $form->field($model, 'nomor_inventaris')->textInput(['maxlength' => true]) ?>

     <div class="form-group">
    <label>Password</label>
    <div class="input-group">
        <?= $form->field($model, 'password', [
            'options' => ['tag' => false]
        ])->passwordInput([
            'maxlength' => true,
            'id' => 'password-field',
            'class' => 'form-control'
        ])->label(false) ?>
        <div class="input-group-append">
            <span class="input-group-text" id="toggle-password" style="cursor:pointer;">
                <i class="fas fa-eye"></i>
            </span>
        </div>
    </div>
</div>
    
<!-- Bagian baru: Contributors (4 baris vertikal) -->
<table class="table table-bordered">
    <thead>
        <tr>
            <th>Family Name</th>
            <th>Given Name / Initials</th>
            <th>NIDN/NIDK</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><?= $form->field($model, 'contributor1_family')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'contributor1_given')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'nidn1')->textInput()->label(false) ?></td>
        </tr>
        <tr>
            <td><?= $form->field($model, 'contributor2_family')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'contributor2_given')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'nidn2')->textInput()->label(false) ?></td>
        </tr>
        <tr>
            <td><?= $form->field($model, 'contributor3_family')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'contributor3_given')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'nidn3')->textInput()->label(false) ?></td>
        </tr>
        <tr>
            <td><?= $form->field($model, 'contributor4_family')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'contributor4_given')->textInput()->label(false) ?></td>
            <td><?= $form->field($model, 'nidn4')->textInput()->label(false) ?></td>
        </tr>
    </tbody>
</table>

    <div class="form-group">
        <?= Html::submitButton('Simpan', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php
$urlJenjang = Url::to(['pendaftaran/get-jenjang']);
$urlProdi = Url::to(['pendaftaran/get-prodi']);
$js = <<<JS
// Dropdown Fakultas -> Jenjang
$('#fakultas-id').change(function() {
    var fid = $(this).val();
    $.get('$urlJenjang', { fakultas_id: fid }, function(data) {
        $('#jenjang-id').empty().append('<option>Pilih Jenjang</option>');
        $.each(data, function(id, nama) {
            $('#jenjang-id').append(new Option(nama, id));
        });
        $('#prodi-id').empty().append('<option>Pilih Prodi</option>');
    });
});

// Dropdown Jenjang -> Prodi
$('#jenjang-id').change(function() {
    var fid = $('#fakultas-id').val();
    var jid = $(this).val();
    $.get('$urlProdi', { fakultas_id: fid, jenjang_id: jid }, function(data) {
        $('#prodi-id').empty().append('<option>Pilih Prodi</option>');
        $.each(data, function(id, nama) {
            $('#prodi-id').append(new Option(nama, id));
        });
    });
});

// Toggle Password Visibility
$('#toggle-password').on('click', function() {
    var input = $('#password-field');
    var icon = $(this).find('i');
    if (input.attr('type') === 'password') {
        input.attr('type', 'text');
        icon.removeClass('fa-eye').addClass('fa-eye-slash');
    } else {
        input.attr('type', 'password');
        icon.removeClass('fa-eye-slash').addClass('fa-eye');
    }
});
JS;
$this->registerJs($js);
?>

