<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Formulir Pendaftaran';
$isEditable = !isset($model->status) || $model->status === 'revisi';
?>

<h1><?= Html::encode($this->title) ?></h1>

<?php if (Yii::$app->session->hasFlash('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= Yii::$app->session->getFlash('success') ?>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">×</span>
        </button>
    </div>
<?php endif; ?>

<?php if (Yii::$app->session->hasFlash('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= Yii::$app->session->getFlash('error') ?>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">×</span>
        </button>
    </div>
<?php endif; ?>

<?php if (!$isEditable): ?>
    <div class="alert alert-info">
        Pengajuan Anda sudah dikirim dan sedang diproses. Anda hanya dapat mengedit kembali jika status menjadi "Revisi".
        <a href="<?= Url::to(['status']) ?>" class="alert-link">Lihat Status</a>
    </div>
<?php endif; ?>

<?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

<?= $form->field($model, 'email')->textInput(['readonly' => true]) ?>
<?= $form->field($model, 'judul_karya_ilmiah')->textInput(['readonly' => !$isEditable]) ?>
<?= $form->field($model, 'nama_lengkap')->textInput(['readonly' => !$isEditable]) ?>
<?= $form->field($model, 'nim')->textInput(['readonly' => !$isEditable]) ?>
<?= $form->field($model, 'fakultas_id')->dropDownList($fakultas, [
    'prompt' => 'Pilih Fakultas',
    'id' => 'fakultas-id',
    'disabled' => !$isEditable,
]) ?>
<?= $form->field($model, 'jenjang_id')->dropDownList($jenjang, [
    'prompt' => 'Pilih Jenjang',
    'id' => 'jenjang-id',
    'disabled' => !$isEditable,
]) ?>
<?= $form->field($model, 'prodi_id')->dropDownList($prodi, [
    'prompt' => 'Pilih Prodi',
    'id' => 'prodi-id',
    'disabled' => !$isEditable,
]) ?>
<?= $form->field($model, 'pembimbing_1')->textInput(['readonly' => !$isEditable]) ?>
<?= $form->field($model, 'pembimbing_2')->textInput(['readonly' => !$isEditable]) ?>
<?= $form->field($model, 'unggah_lembar_persetujuan_file')->fileInput(['disabled' => !$isEditable]) ?>
<?= $form->field($model, 'nomor_handphone')->textInput(['readonly' => !$isEditable]) ?>
<?= $form->field($model, 'jenis_kelamin')->dropDownList(
    ['L' => 'Laki-laki', 'P' => 'Perempuan'],
    ['prompt' => 'Pilih', 'disabled' => !$isEditable]
) ?>

<?php if ($model->file_path): ?>
    <p>
        File saat ini:
        <?= Html::a('Download File', Yii::getAlias('@web/' . $model->file_path), ['target' => '_blank']) ?>
    </p>
<?php endif; ?>

<div class="form-group">
    <label>Status</label>
    <p class="form-control-static"><?= Html::encode($model->status ?? 'Belum Diajukan') ?></p>
</div>

<div class="form-group">
    <label>Setuju</label>
    <p class="form-control-static"><?= Html::encode($model->setuju ?? '-') ?></p>
</div>

<?php if ($isEditable): ?>
    <div class="form-group">
        <?= Html::submitButton('Kirim', ['class' => 'btn btn-success']) ?>
    </div>
<?php endif; ?>

<?php ActiveForm::end(); ?>

<?php if ($isEditable): ?>
<?php
$urlJenjang = Url::to(['form/get-jenjang']);
$urlProdi = Url::to(['form/get-prodi']);
$js = <<<JS
$(document).ready(function() {
    var fakultasId = $('#fakultas-id').val();
    var jenjangId = $('#jenjang-id').val();

    if (fakultasId) {
        $.get('$urlJenjang', { fakultas_id: fakultasId })
            .done(function(data) {
                $('#jenjang-id').empty().append('<option>Pilih Jenjang</option>').prop('disabled', false);
                $.each(data, function(id, nama) {
                    $('#jenjang-id').append(new Option(nama, id));
                });
                if (jenjangId) {
                    $('#jenjang-id').val(jenjangId);
                    $.get('$urlProdi', { fakultas_id: fakultasId, jenjang_id: jenjangId })
                        .done(function(data) {
                            $('#prodi-id').empty().append('<option>Pilih Prodi</option>').prop('disabled', false);
                            $.each(data, function(id, nama) {
                                $('#prodi-id').append(new Option(nama, id));
                            });
                            $('#prodi-id').val('{$model->prodi_id}');
                        });
                }
            });
    }

    $('#fakultas-id').change(function() {
        var fid = $(this).val();
        $('#jenjang-id').html('<option>Loading...</option>').prop('disabled', true);
        $('#prodi-id').html('<option>Pilih Prodi</option>').prop('disabled', true);
        $.get('$urlJenjang', { fakultas_id: fid })
            .done(function(data) {
                $('#jenjang-id').empty().append('<option>Pilih Jenjang</option>').prop('disabled', false);
                $.each(data, function(id, nama) {
                    $('#jenjang-id').append(new Option(nama, id));
                });
                $('#prodi-id').empty().append('<option>Pilih Prodi</option>');
            })
            .fail(function() {
                alert('Gagal memuat data jenjang. Silakan coba lagi.');
                $('#jenjang-id').empty().append('<option>Pilih Jenjang</option>').prop('disabled', false);
            });
    });

    $('#jenjang-id').change(function() {
        var fid = $('#fakultas-id').val();
        var jid = $(this).val();
        $('#prodi-id').html('<option>Loading...</option>').prop('disabled', true);
        $.get('$urlProdi', { fakultas_id: fid, jenjang_id: jid })
            .done(function(data) {
                $('#prodi-id').empty().append('<option>Pilih Prodi</option>').prop('disabled', false);
                $.each(data, function(id, nama) {
                    $('#prodi-id').append(new Option(nama, id));
                });
            })
            .fail(function() {
                alert('Gagal memuat data prodi. Silakan coba lagi.');
                $('#prodi-id').empty().append('<option>Pilih Prodi</option>').prop('disabled', false);
            });
    });
});
JS;
$this->registerJs($js);
?>
<?php endif; ?>