<?php
use yii\helpers\Html;

$this->title = 'Beranda';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Selamat Datang di PortalSSO</h3>
                </div>
                <div class="card-body">
                    <?php if (Yii::$app->user->isGuest): ?>
                        <?= Html::a('Login', ['/user/security/login'], ['class' => 'btn btn-primary']) ?>
                        <?= Html::a('Register', ['/user/registration/register'], ['class' => 'btn btn-success']) ?>
                    <?php else: ?>
                        <p>Halo, <?= Html::encode(Yii::$app->user->identity->username) ?>!</p>
                        <?= Html::a('Logout', ['/user/security/logout'], [
                            'data-method' => 'post',
                            'class' => 'btn btn-danger'
                        ]) ?>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>
</div>
