<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;

/** @var yii\web\View $this */
/** @var \Da\User\Form\LoginForm $model */

$this->title = 'Sign in';
?>

<div class="row align-items-center">
    <div class="col"></div>
    <div class="col-xs-8 col-sm-7 col-md-6 col-lg-5 col-xl-4 ">
        <div class="card">
            <div class="card-header">
                <h3 class="m-0"><?= Html::encode($this->title) ?></h3>
            </div>
            <div class="card-body">
                <?php $form = ActiveForm::begin([
                    'id' => $model->formName(),
                    'enableAjaxValidation' => true,
                    'enableClientValidation' => false,
                    'validateOnBlur' => false,
                    'validateOnType' => false,
                    'validateOnChange' => false,
                ]) ?>

                <?= $form->field($model, 'login', [
                    'inputOptions' => [
                        'autofocus' => 'autofocus',
                        'class' => 'form-control',
                        'tabindex' => '1',
                    ]
                ]) ?>

                <?= $form->field($model, 'password', [
                        'inputOptions' => ['class' => 'form-control', 'tabindex' => '2']
                    ])
                    ->passwordInput()
                    ->label(
                        'Password (' .
                        Html::a('Forgot password?', ['/user/recovery/request'], ['tabindex' => '5']) .
                        ')'
                    )
                ?>

                <?= $form->field($model, 'rememberMe')->checkbox(['tabindex' => '4']) ?>

                <?= Html::submitButton('Sign in', [
                    'class' => 'btn btn-primary btn-block',
                    'tabindex' => '3'
                ]) ?>

                <?php ActiveForm::end(); ?>
            </div>
        </div>

        <p class="text-center mt-3">
            <?= Html::a('Don\'t have an account? Sign up!', ['/user/registration/register']) ?>
        </p>
    </div>
    <div class="col"></div>
</div>
