<?php

namespace backend\controllers;

use Yii;
use yii\helpers\ArrayHelper;
use yii\web\Response;
use backend\models\Pendaftaran;
use backend\models\PendaftaranSearch;
use backend\models\Fakultas;
use backend\models\Jenjang;
use backend\models\Prodi;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;

/**
 * PendaftaranController implements the CRUD actions for Pendaftaran model.
 */
class PendaftaranController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $searchModel = new PendaftaranSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionCreate()
    {
        $model = new Pendaftaran();
    
        if ($model->load(Yii::$app->request->post())) {
            $model->fileUpload = UploadedFile::getInstance($model, 'fileUpload');
            if ($model->fileUpload && $model->fileUpload->tempName && is_uploaded_file($model->fileUpload->tempName)) {
                
                $uploadDir = Yii::getAlias('@app/../uploadspersetujuan/');
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }
    
                $fileName = uniqid() . '.' . $model->fileUpload->extension;
                $filePath = $uploadDir . $fileName;
    
                if ($model->fileUpload->saveAs($filePath, false)) {
                    $model->file_path = 'uploadspersetujuan/' . $fileName;
                }
            }
    
            if ($model->save(false)) {
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }
    
        $fakultasList = ArrayHelper::map(Fakultas::find()->all(), 'id', 'nama');
        $jenjangList  = ArrayHelper::map(Jenjang::find()->all(), 'id', 'nama');
        $prodiList    = ArrayHelper::map(Prodi::find()->all(), 'id', 'nama');
    
        return $this->render('create', [
            'model'        => $model,
            'fakultasList' => $fakultasList,
            'jenjangList'  => $jenjangList,
            'prodiList'    => $prodiList,
        ]);
    }

    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $oldFile = $model->file_path;

        if ($model->load($this->request->post())) {
            $model->fileUpload = UploadedFile::getInstance($model, 'fileUpload');

            if ($model->fileUpload && $model->fileUpload->tempName && is_uploaded_file($model->fileUpload->tempName)) {
                
                $uploadDir = Yii::getAlias('@app/../uploadspersetujuan/');
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }

                // hapus file lama kalau ada
                if ($oldFile && file_exists(Yii::getAlias('@app/../') . $oldFile)) {
                    @unlink(Yii::getAlias('@app/../') . $oldFile);
                }

                $fileName = uniqid() . '.' . $model->fileUpload->extension;
                $filePath = $uploadDir . $fileName;

                if ($model->fileUpload->saveAs($filePath, false)) {
                    $model->file_path = 'uploadspersetujuan/' . $fileName;
                }
            } else {
                $model->file_path = $oldFile;
            }

            if ($model->save(false)) {
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    public function actionGetJenjang($fakultas_id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $jenjang = Jenjang::find()->where(['fakultas_id' => $fakultas_id])->all();
        return ArrayHelper::map($jenjang, 'id', 'nama');
    }

    public function actionGetProdi($fakultas_id, $jenjang_id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $prodi = Prodi::find()
            ->where(['fakultas_id' => $fakultas_id, 'jenjang_id' => $jenjang_id])
            ->all();
        return ArrayHelper::map($prodi, 'id', 'nama');
    }

    public function actionDelete($id)
    {
        $model = $this->findModel($id);

        if ($model->file_path && file_exists(Yii::getAlias('@app/../') . $model->file_path)) {
            @unlink(Yii::getAlias('@app/../') . $model->file_path);
        }

        $model->delete();
        return $this->redirect(['index']);
    }

    protected function findModel($id)
    {
        if (($model = Pendaftaran::findOne(['id' => $id])) !== null) {
            return $model;
        }
        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
