<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Prodi;

class ProdiSearch extends Prodi
{
    public $fakultas_nama;
    public $jenjang_nama;

    public function rules()
    {
        return [
            [['id', 'fakultas_id', 'jenjang_id'], 'integer'],
            [['nama', 'kode_prodi', 'fakultas_nama', 'jenjang_nama'], 'safe'],
        ];
    }

    public function scenarios()
    {
        return Model::scenarios();
    }

    public function search($params)
    {
        $query = Prodi::find()->joinWith(['fakultas', 'jenjang']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        // Tambahkan sorting untuk nama fakultas dan jenjang
        $dataProvider->sort->attributes['fakultas_nama'] = [
            'asc' => ['fakultas.nama' => SORT_ASC],
            'desc' => ['fakultas.nama' => SORT_DESC],
        ];
        $dataProvider->sort->attributes['jenjang_nama'] = [
            'asc' => ['jenjang.nama' => SORT_ASC],
            'desc' => ['jenjang.nama' => SORT_DESC],
        ];

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        // Filter berdasarkan fakultas_nama dan jenjang_nama
        $query->andFilterWhere(['like', 'fakultas.nama', $this->fakultas_nama]);
        $query->andFilterWhere(['like', 'jenjang.nama', $this->jenjang_nama]);

        $query->andFilterWhere([
            'id' => $this->id,
            'fakultas_id' => $this->fakultas_id,
            'jenjang_id' => $this->jenjang_id,
            'nama' => $this->nama,
            'kode_prodi' => $this->kode_prodi,
        ]);

        return $dataProvider;
    }
}