<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\Fakultas;
use backend\models\Jenjang;
use backend\models\Prodi;

/** @var yii\web\View $this */
/** @var backend\models\Pendaftaran $model */
/** @var yii\widgets\ActiveForm $form */

// Helper: tentukan kolom label yang tersedia pada relasi secara dinamis
$resolveLabelAttr = function($className, $candidates) {
    $first = $className::find()->one();
    if ($first) {
        foreach ($candidates as $attr) {
            if (method_exists($first, 'hasAttribute') && $first->hasAttribute($attr)) {
                return $attr;
            }
        }
    }
    return 'id';
};

$fakultasLabel = $resolveLabelAttr(Fakultas::class, ['nama_fakultas','nama','name','title']);
$jenjangLabel  = $resolveLabelAttr(Jenjang::class,  ['nama_jenjang','nama','name','title']);
$prodiLabel    = $resolveLabelAttr(Prodi::class,    ['nama_prodi','nama','name','title']);
?>

<div class="pendaftaran-form">

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

    <!-- Data Utama -->
    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'judul_karya_ilmiah')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'nama_lengkap')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'nim')->textInput(['maxlength' => true]) ?>

    <!-- Relasi Akademik -->
    <?= $form->field($model, 'fakultas_id')->dropDownList(
        ArrayHelper::map(Fakultas::find()->all(), 'id', 'nama'),
        ['prompt' => 'Pilih Fakultas', 'id' => 'fakultas-id']
    ) ?>

    <?= $form->field($model, 'jenjang_id')->dropDownList(
        $model->isNewRecord ? [] : ArrayHelper::map(
            Jenjang::find()->where(['fakultas_id' => $model->fakultas_id])->all(),
            'id', 'nama'
        ),
        ['prompt' => 'Pilih Jenjang', 'id' => 'jenjang-id']
    ) ?>

    <?= $form->field($model, 'prodi_id')->dropDownList(
        $model->isNewRecord ? [] : ArrayHelper::map(
            Prodi::find()->where([
                'fakultas_id' => $model->fakultas_id,
                'jenjang_id'  => $model->jenjang_id
            ])->all(),
            'id', 'nama'
        ),
        ['prompt' => 'Pilih Prodi', 'id' => 'prodi-id']
    ) ?>





    <!-- Pembimbing -->
    <?= $form->field($model, 'pembimbing_1')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'pembimbing_2')->textInput(['maxlength' => true]) ?>

    <!-- Info Tambahan -->
    <?= $form->field($model, 'nomor_handphone')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'jenis_kelamin')->dropDownList(
        ['L' => 'Laki-laki', 'P' => 'Perempuan'],
        ['prompt' => 'Pilih']
    ) ?>
    <?= $form->field($model, 'nomor_inventaris')->textInput(['maxlength' => true]) ?>

    <!-- Password -->
    <label>Password</label>
    <div class="input-group mb-3">
        <?= $form->field($model, 'password', [
            'options' => ['tag' => false]
        ])->passwordInput([
            'maxlength' => true,
            'id' => 'password-field',
            'class' => 'form-control'
        ])->label(false) ?>
        <button type="button" class="btn btn-outline-secondary" id="toggle-password">
            <i class="fas fa-eye"></i>
        </button>
    </div>

    <!-- Contributors -->
    <h5>Contributors</h5>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Family Name</th>
                <th>Given Name / Initials</th>
                <th>NIDN/NIDK</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= $form->field($model, 'contributor1_family')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'contributor1_given')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'nidn1')->textInput()->label(false) ?></td>
            </tr>
            <tr>
                <td><?= $form->field($model, 'contributor2_family')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'contributor2_given')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'nidn2')->textInput()->label(false) ?></td>
            </tr>
            <tr>
                <td><?= $form->field($model, 'contributor3_family')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'contributor3_given')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'nidn3')->textInput()->label(false) ?></td>
            </tr>
            <tr>
                <td><?= $form->field($model, 'contributor4_family')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'contributor4_given')->textInput()->label(false) ?></td>
                <td><?= $form->field($model, 'nidn4')->textInput()->label(false) ?></td>
            </tr>
        </tbody>
    </table>

    <hr>

    <!-- Upload File -->
    <?= $form->field($model, 'fileUpload')->fileInput() ?>
    <?php if ($model->file_path): ?>
        <p>
            File saat ini:
            <?= Html::a('Download File', Yii::getAlias('@web/' . $model->file_path), ['target' => '_blank']) ?>
        </p>
    <?php endif; ?>

    <hr>

    <!-- Status -->
    <?= $form->field($model, 'status')->dropDownList([
        'on process' => 'On Process',
        'revisi'     => 'Revisi',
        'ditolak'    => 'Ditolak',
        'disetujui'  => 'Disetujui',
    ], ['prompt' => 'Pilih Status']) ?>

    <?= $form->field($model, 'status_persetujuan')->textInput(['readonly' => true]) ?>
    <?= $form->field($model, 'jumlah_revisi')->textInput(['readonly' => true]) ?>

    <div class="form-group mt-3">
        <?= Html::submitButton('Simpan', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php
// URL untuk AJAX
$urlJenjang = Url::to(['pendaftaran/get-jenjang']);
$urlProdi   = Url::to(['pendaftaran/get-prodi']);

$selectedJenjang = $model->jenjang_id;
$selectedProdi   = $model->prodi_id;

$js = <<<JS
// Toggle show/hide password
$('#toggle-password').click(function() {
    var input = $('#password-field');
    var icon = $(this).find('i');
    if (input.attr('type') === 'password') {
        input.attr('type', 'text');
        icon.removeClass('fa-eye').addClass('fa-eye-slash');
    } else {
        input.attr('type', 'password');
        icon.removeClass('fa-eye-slash').addClass('fa-eye');
    }
});

// Fakultas -> Jenjang
$('#fakultas-id').change(function() {
    var fid = $(this).val();
    $.get('$urlJenjang', { fakultas_id: fid }, function(data) {
        $('#jenjang-id').empty().append('<option value="">Pilih Jenjang</option>');
        $.each(data, function(id, nama) {
            $('#jenjang-id').append(new Option(nama, id));
        });
        $('#prodi-id').empty().append('<option value="">Pilih Prodi</option>');
    });
});

// Jenjang -> Prodi
$('#jenjang-id').change(function() {
    var fid = $('#fakultas-id').val();
    var jid = $(this).val();
    $.get('$urlProdi', { fakultas_id: fid, jenjang_id: jid }, function(data) {
        $('#prodi-id').empty().append('<option value="">Pilih Prodi</option>');
        $.each(data, function(id, nama) {
            $('#prodi-id').append(new Option(nama, id));
        });
    });
});

// ==== PRELOAD saat update ==== 
var currentJenjang = '$selectedJenjang';
var currentProdi   = '$selectedProdi';

if ($('#fakultas-id').val()) {
    // trigger fakultas untuk isi jenjang
    $('#fakultas-id').trigger('change');
    setTimeout(function() {
        if (currentJenjang) {
            $('#jenjang-id').val(currentJenjang).trigger('change');
        }
    }, 500);
    setTimeout(function() {
        if (currentProdi) {
            $('#prodi-id').val(currentProdi);
        }
    }, 1000);
}
JS;
$this->registerJs($js);
?>