<?php

use backend\models\Prodi; // Perbaiki namespace dari frontend ke backend
use backend\models\Fakultas;
use backend\models\Jenjang;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

/** @var yii\web\View $this */
/** @var backend\models\ProdiSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Prodis';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="prodi-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Prodi', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            [
                'attribute' => 'fakultas_id',
                'label' => 'Fakultas',
                'value' => function ($model) {
                    return $model->fakultas ? $model->fakultas->nama : '-';
                },
                'filter' => Prodi::getFakultasList(), // Gunakan helper dari model
            ],
            [
                'attribute' => 'jenjang_id',
                'label' => 'Jenjang',
                'value' => function ($model) {
                    return $model->jenjang ? $model->jenjang->nama : '-';
                },
                'filter' => Prodi::getJenjangList(), // Gunakan helper dari model
            ],
            'nama',
            'kode_prodi',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, Prodi $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                }
            ],
        ],
    ]); ?>

</div>