<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-frontend',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'layout' => 'main',
    'defaultRoute' => 'user/security/login',
    'controllerNamespace' => 'frontend\controllers',
    'modules' => [
    'user' => [
        'class' => Da\User\Module::class,
        'controllerMap' => [
            'security' => 'frontend\controllers\user\SecurityController',
        ],
            ],
        ],
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-frontend',
        ],
        'user' => [
        'identityClass' => Da\User\Model\User::class,
        'enableAutoLogin' => true,
        'loginUrl' => ['user/security/login'],
    ],
        'session' => [
            // this is the name of the session cookie used for login on the frontend
            'name' => 'advanced-frontend',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => \yii\log\FileTarget::class,
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],

        'view' => [
    'class' => yii\web\View::class,
    'theme' => [
        'pathMap' => [
            '@Da/User/resources/views' => '@app/views/usuario',
            '@Da/User/resources/views/bootstrap5/layouts' => '@app/views/layouts',
        ],
    ],
],
        /*
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
            ],
        ],
        */
    ],
    'params' => $params,
];
