<?php

namespace frontend\models;

use Yii;
use yii\web\UploadedFile;

/**
 * This is the model class untuk table "pendaftaran".
 * (menggunakan ActiveRecord dari database yang sama dengan backend)
 */
class FormData extends \yii\db\ActiveRecord
{
    /**
     * @var UploadedFile
     */
    public $unggah_lembar_persetujuan_file;

    /**
     * Flag penanda apakah model dipanggil dari frontend
     * supaya status otomatis diset ulang jika revisi diperbaiki.
     */
    public $isFrontend = true;

    public static function tableName()
    {
        return 'pendaftaran';
    }

    public function rules()
    {
        return [
            [['email', 'judul_karya_ilmiah', 'nama_lengkap', 'nim', 'fakultas_id', 'jenjang_id', 'prodi_id', 'pembimbing_1', 'nomor_handphone', 'jenis_kelamin'], 'required'],
            [['fakultas_id', 'jenjang_id', 'prodi_id', 'jumlah_revisi'], 'integer'],
            [['status', 'status_persetujuan'], 'string', 'max' => 50],
            [['email', 'judul_karya_ilmiah', 'nama_lengkap', 'nim', 'pembimbing_1', 'pembimbing_2', 'nomor_handphone', 'jenis_kelamin'], 'string', 'max' => 255],
            [['nomor_inventaris', 'password', 'nidn1', 'nidn2'], 'safe'],

            [['file_path'], 'string', 'max' => 255],
            [['unggah_lembar_persetujuan_file'], 'file', 'skipOnEmpty' => true, 'extensions' => 'pdf,doc,docx,jpg,png'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'email' => 'Email',
            'judul_karya_ilmiah' => 'Judul Karya Ilmiah',
            'nama_lengkap' => 'Nama Lengkap',
            'nim' => 'NIM',
            'fakultas_id' => 'Fakultas',
            'jenjang_id' => 'Jenjang',
            'prodi_id' => 'Program Studi',
            'pembimbing_1' => 'Pembimbing 1',
            'pembimbing_2' => 'Pembimbing 2',
            'nomor_handphone' => 'Nomor Handphone',
            'jenis_kelamin' => 'Jenis Kelamin',
            'status' => 'Status',
            'status_persetujuan' => 'Status Persetujuan',
            'jumlah_revisi' => 'Jumlah Revisi',
            'file_path' => 'File Upload',
        ];
    }

    /**
     * Relasi ke tabel fakultas/jenjang/prodi
     */
    public function getFakultas()
    {
        return $this->hasOne(Fakultas::class, ['id' => 'fakultas_id']);
    }

    public function getJenjang()
    {
        return $this->hasOne(Jenjang::class, ['id' => 'jenjang_id']);
    }

    public function getProdi()
    {
        return $this->hasOne(Prodi::class, ['id' => 'prodi_id']);
    }

    /**
     * Override sebelum simpan data.
     * Jika frontend mengirim revisi yang diperbaiki, ubah status kembali ke on process.
     */
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            // Jika ini frontend dan status terakhir revisi
            if ($this->isFrontend && $this->status === 'revisi') {
                $this->status = 'on process';
                $this->status_persetujuan = 'on process';
            }
            return true;
        }
        return false;
    }

    public function getStatusLabel()
{
    $statusLabels = [
        'on process' => 'Sedang Diproses',
        'revisi' => 'Perlu Revisi',
        'approved' => 'Disetujui',
        'rejected' => 'Ditolak',
        // Add other statuses as needed
    ];

    return isset($statusLabels[$this->status]) ? $statusLabels[$this->status] : $this->status;
}
}
