<?php
use yii\helpers\Html;

$adaDisetujui = false;
foreach ($models as $m) {
    if (strtolower($m->status) === 'disetujui') {
        $adaDisetujui = true;
        break;
    }
}
?>

<h2>Status Pengajuan Anda</h2>

<?php if (empty($models)): ?>
    <p>Belum ada pengajuan.</p>
<?php else: ?>
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <?php if ($adaDisetujui): ?>
                        <th>Judul Karya Ilmiah</th>
                        <th>Nama Lengkap</th>
                        <th>NIM</th>
                        <th>Fakultas</th>
                        <th>Jenjang</th>
                        <th>Prodi</th>
                        <th>Pembimbing 1</th>
                        <th>Pembimbing 2</th>
                        <th>Unggah Lembar Persetujuan</th>
                        <th>Nomor Handphone</th>
                        <th>Jenis Kelamin</th>
                        <th>Status</th>
                        <th>Nomor Inventaris</th>
                        <th>Username</th>
                        <th>Password</th>
                        <th>NIDN Dosen Pembimbing 1</th>
                        <th>NIDN Dosen Pembimbing 2</th>
                        <th>Aksi</th>
                    <?php else: ?>
                        <th>Judul Karya Ilmiah</th>
                        <th>Prodi</th>
                        <th>Status</th>
                        <th>Diajukan Pada</th>
                        <th>Unggah Lembar Persetujuan</th>
                        <th>Password</th>
                        <th>Aksi</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($models as $model): ?>
                    <tr>
                        <?php if ($adaDisetujui): ?>

                            <td><?= Html::encode($model->judul_karya_ilmiah) ?></td>
                            <td><?= Html::encode($model->nama_lengkap) ?></td>
                            <td><?= Html::encode($model->nim) ?></td>
                            <td><?= Html::encode($model->fakultas ? $model->fakultas->nama : '-') ?></td>
                            <td><?= Html::encode($model->jenjang ? $model->jenjang->nama : '-') ?></td>
                            <td><?= Html::encode($model->prodi ? $model->prodi->nama : '-') ?></td>
                            <td><?= Html::encode($model->pembimbing_1) ?></td>
                            <td><?= Html::encode($model->pembimbing_2) ?></td>
                            <td>
                                <?php if ($model->unggah_lembar_persetujuan): ?>
                                    <?= Html::a('Lihat File', ['form/download', 'id' => $model->id], ['class' => 'btn btn-sm btn-info', 'target' => '_blank']) ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td><?= Html::encode($model->nomor_handphone) ?></td>
                            <td><?= Html::encode($model->jenis_kelamin) ?></td>
                            <td><span class="badge badge-<?= $model->status === 'disetujui' ? 'success' : ($model->status === 'ditolak' ? 'danger' : ($model->status === 'revisi' ? 'warning' : 'primary')) ?>">
                                <?= Html::encode($model->getStatusLabel()) ?>
                            </span></td>
                            <td><?= Html::encode($model->nomor_inventaris ?? '-') ?></td>
                            <td><?= Html::encode($model->email) ?></td>
                            <td>
                                <?php if ($model->status === 'disetujui' && $model->password): ?>
                                    <span class="password-text" data-password="<?= Html::encode($model->password) ?>" style="display: none;"><?= Html::encode($model->password) ?></span>
                                    <span class="password-mask">••••••••</span>
                                    <button type="button" class="btn btn-sm btn-outline-secondary toggle-password">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td><?= Html::encode($model->nidn1 ?? '-') ?></td>
                            <td><?= Html::encode($model->nidn2 ?? '-') ?></td>
                            <td>
                                <?php if ($model->status === 'revisi'): ?>
                                    <?= Html::a('Edit', ['form/update', 'id' => $model->id], ['class' => 'btn btn-sm btn-primary']) ?>
                                <?php endif; ?>
                            </td>
                        <?php else: ?>
                            
                            <td><?= Html::encode($model->judul_karya_ilmiah) ?></td>
                            <td><?= Html::encode($model->prodi ? $model->prodi->nama : '-') ?></td>
                            <td><span class="badge badge-<?= $model->status === 'disetujui' ? 'success' : ($model->status === 'ditolak' ? 'danger' : ($model->status === 'revisi' ? 'warning' : 'primary')) ?>">
                                <?= Html::encode($model->getStatusLabel()) ?>
                            </span></td>
                            <td><?= $model->created_at ? Html::encode(date('d-m-Y', strtotime($model->created_at))) : '-' ?></td> <!-- Selalu tampilkan kolom ini -->
                            <td>
                            <?php if ($model->file_path): ?>
                                    <?= Html::a('Lihat File', ['form/download', 'id' => $model->id], ['class' => 'btn btn-sm btn-info', 'target' => '_blank']) ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($model->status === 'disetujui' && $model->password): ?>
                                    <span class="password-text" data-password="<?= Html::encode($model->password) ?>" style="display: none;"><?= Html::encode($model->password) ?></span>
                                    <span class="password-mask">••••••••</span>
                                    <button type="button" class="btn btn-sm btn-outline-secondary toggle-password">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($model->status === 'revisi'): ?>
                                    <?= Html::a('Edit', ['form/update', 'id' => $model->id], ['class' => 'btn btn-sm btn-primary']) ?>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<style>
    .badge-primary { background-color: #007bff !important; color: #fff !important; }
    .badge-success { background-color: #28a745 !important; color: #fff !important; }
    .badge-warning { background-color: #ffc107 !important; color: #000 !important; }
    .badge-danger { background-color: #dc3545 !important; color: #fff !important; }
    .password-mask { display: inline; }
    .password-text { display: none; }
</style>

<?php
$this->registerJsFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js', ['position' => \yii\web\View::POS_HEAD]);
$this->registerJs(<<<JS
$('.toggle-password').click(function() {
    var button = $(this);
    var passwordText = button.siblings('.password-text');
    var passwordMask = button.siblings('.password-mask');
    if (passwordText.is(':visible')) {
        passwordText.hide();
        passwordMask.show();
        button.find('i').removeClass('fa-eye-slash').addClass('fa-eye');
    } else {
        passwordText.show();
        passwordMask.hide();
        button.find('i').removeClass('fa-eye').addClass('fa-eye-slash');
    }
});
JS);
?>