<?php

use yii\helpers\Html;
use yii\helpers\Url;
use frontend\assets\AdminLteAsset;
use yii\widgets\Breadcrumbs;

AdminLteAsset::register($this);
$user = Yii::$app->user->identity;

?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
  <meta charset="<?= Yii::$app->charset ?>">
  <?= Html::csrfMetaTags() ?>
  <title><?= Html::encode($this->title) ?></title>
  <?php $this->head() ?>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<?php $this->beginBody() ?>
<div class="wrapper">

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
      <?php if (!Yii::$app->user->isGuest): ?>
        <li class="nav-item">
          <?= Html::beginForm(['/user/security/logout'], 'post')
              . Html::submitButton('Logout (' . Html::encode($user->username) . ')', ['class' => 'btn btn-link logout'])
              . Html::endForm() ?>
        </li>
      <?php endif; ?>
    </ul>
  </nav>

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?= Url::to(['/']) ?>" class="brand-link">
      <img src="https://kori.unsoed.ac.id/images/gunungan.png" alt="Logo" class="brand-image img-circle elevation-3">
      <span class="brand-text font-weight-light">Portal SSO</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
          <li class="nav-item">
            <a href="<?= Url::to(['/site/index']) ?>" class="nav-link">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>Dashboard</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="<?= Url::to(['/user/admin/index']) ?>" class="nav-link">
              <i class="nav-icon fas fa-users"></i>
              <p>User Management</p>
            </a>
          </li>
          <!-- Tambahkan link lainnya sesuai kebutuhan -->
        </ul>
      </nav>
    </div>
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <section class="content pt-3">
      <div class="container-fluid">
        <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs'] ?? []]) ?>
        <?= $content ?>
      </div>
    </section>
  </div>

  <!-- Main Footer -->
  <footer class="main-footer text-center">
    <strong>&copy; <?= date('Y') ?> Portal SSO UNJ</strong>
  </footer>
</div>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
